DROP PROCEDURE [hips].[PatientMasterIhiHistoryInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 27 July 2012
-- Description:   Inserts a new record into the PatientMasterIhiHistory Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterIhiHistoryInsert] 
(
	  @PatientMasterId INT
	, @Ihi VARCHAR(50) = NULL
	, @IhiRecordStatusId INT
	, @IhiStatusId INT
	, @UserModified VARCHAR(256)
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @IhiHistoryId int

    SET @intErrorCode = 0

    INSERT
     INTO [hips].[PatientMasterIhiHistory]
         ( [PatientMasterId]
         , [Ihi]
         , [IhiRecordStatusId]
         , [IhiStatusId]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         )
    VALUES
         ( @PatientMasterId
         , @Ihi
         , @IhiRecordStatusId
         , @IhiStatusId
         , GETDATE()
         , @UserModified
         , GETDATE()
         , @UserModified
         )

    SELECT @intErrorCode = @@ERROR , @IhiHistoryId = SCOPE_IdENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [IhiHistoryId]
             , [PatientMasterId]
             , [Ihi]
             , [IhiRecordStatusId]
			 , [IhiStatusId]
             , [DateCreated]
             , [UserCreated]
             , [DateModified]
             , [UserModified]
         FROM [hips].[PatientMasterIhiHistory]
         WHERE [IhiHistoryId] = @IhiHistoryId
    END

    RETURN(@intErrorCode)
END
GO

